<?php defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require APPPATH.'/libraries/DaaS_REST_Controller.php';

class Admin extends DaaS_REST_Controller
{
	public function create_user_post() {		
		$error = false;
		$fields = array();
		$request_id = $this->create_request($this->request->uri . ' ' . strtoupper($this->request->method));
		$response_message['request_id'] = $request_id;
		$is_authenticated = $this->request->hmac_authenticated; //authenticate request
		$is_authorized = $this->request->admin_api_authorized; //authorize request
		
		//check parameters for required fields, set defaults for non-required fields that aren't provided
		//TO-DO: username / id should be automatically determined somehow (or at least restricted more) -- id is org id and should be pulled from a certificate ideally
		if(!$this->post('username')) { $error = true; array_push($fields, 'username'); } else { $username = $this->post('username'); }
		if(!$this->post('id')) { $error = true; array_push($fields, 'id'); } else { $id = $this->post('id'); }
		if(!$this->post('first')) { $error = true; array_push($fields, 'first name'); } else { $first = $this->post('first'); }
		if(!$this->post('last')) { $error = true; array_push($fields, 'last name'); } else { $last = $this->post('last'); }
		if(!$this->post('middle')) { $middle = null; } else { $middle = $this->post('middle'); }
		if(!$this->post('mail')) { $ext_mail = ''; } else { $ext_mail = $this->post('mail'); }
		if(!$this->post('title')) { $title = null; } else { $title = $this->post('title'); }
		if(!$this->post('department')) { $department = null; } else { $department = $this->post('department'); }
		if(!$this->post('organization')) { $organization = null; } else { $organization = $this->post('organization'); }
		if(!$this->post('telephone')) { $telephone = null; } else { $telephone = $this->post('telephone'); }
		if(!$this->post('mobile')) { $mobile = null; } else { $mobile = $this->post('mobile'); }
		if(!$this->post('location')) { $location = null; } else { $location = $this->post('location'); }
		
		//if there is an error with the passed in fields create an error message
		if ($error){
			if($is_authenticated) { 
				if($is_authorized) {
					//check authorization here as well
					$response_message['message'] = $this->generate_required_fields_message($fields);
					$response_message['fields'] = $fields;
					$this->requestmodel->add_response($request_id, 422, json_encode($response_message));
					$this->response($response_message, 422);
				}				
			}
		}
		
		//if authentication was successful, check if the app is authorized to use this function
		if($is_authenticated) {
			if($is_authorized) {
				//if authorized perform user creation
				$this->load->model('usersmodel');
				$this->load->model('applicationmodel');
				$app_id = $this->applicationmodel->get_application_id_from_public($this->request->public_key);
				if($this->usersmodel->username_exists($username) === FALSE) {
					if($this->usersmodel->org_id_exists($id) === FALSE) {
						//set constant user attributes
						$attributes = array(
							'objectClass' => array('posixAccount', 'top', 'person', 'organizationalPerson', 'inetOrgPerson'),
							'gidNumber' => '5000',
							'uidNumber' => '5000',
							'uid' => $username,
							'homeDirectory' => '/var/mailboxes/'.$username,
							'mail' => $username.'@'.DIRECT_DOMAIN, //don't confuse this with external mail, this is internal direct address
							'givenName' => $first,
							'sn' => $last,
							'cn' => $first.' '.$last,
						);
						//set optional attributes / attributes that depend on optional attributes
						if(isset($middle)) { 
							$attributes['initials'] = $middle;
							$attributes['displayName'] = $last.', '.$first.' '.$middle;							
						}
						else { $attributes['displayName'] = $last.', '.$first; }	
						if(isset($title)) { $attributes['title'] = $title; }
						if(isset($department)) { $attributes['departmentNumber'] = $department; }
						if(isset($organization)) { $attributes['o'] = $organization; }
						if(isset($telephone)) { $attributes['telephoneNumber'] = $telephone; }
						if(isset($mobile)) { $attributes['mobile'] = $mobile; }
						if(isset($location)) { $attributes['physicalDeliveryOfficeName'] = $location; }
						
						if($this->usersmodel->create_user($username,$app_id,$id,$ext_mail,$attributes)) {
							$response_message['message'] = 'User successfully created.';
							$this->requestmodel->add_response($request_id, 200, json_encode($response_message));
							$this->response($response_message, 200);
						}
						else {
							$response_message['message'] = 'Failed to create user.';
							$this->requestmodel->add_response($request_id, 500, json_encode($response_message));
							$this->response($response_message, 500);
						}
					}
					else { 
						$response_message['message'] = 'Bad Request. User ID already in use.';
						if($this->usersmodel->org_id_linked($id,$app_id)) { $response_message['message'] = 'Bad Request. User ID already in use by this application.'; }
						else if($this->usersmodel->org_id_exists($id)) { $response_message['message'] = 'Bad Request. User ID already in use, but not linked to this application.'; }
						$this->requestmodel->add_response($request_id, 400, json_encode($response_message));
						$this->response($response_message, 400);
					}
				}
				else { 
					$response_message['message'] = 'Bad Request. Username already in use.';
					$this->requestmodel->add_response($request_id, 400, json_encode($response_message));
					$this->response($response_message, 400);
				}
			}
			else {
				$response_message['message'] = 'Access Denied. Use Not Authorized.';
				$this->requestmodel->add_response($request_id, 403, json_encode($response_message));
				$this->response($response_message, 403);
			}
		}
		else { //deny access if authentication fails
			$response_message['message'] = 'Access Denied. Authentication Failed.';
			$this->requestmodel->add_response($request_id, 401, json_encode($response_message));
			$this->response($response_message, 401);
		}
	}
	
	/*Create Group webcall*/
	public function create_group_post() {		
		$error = false;
		$fields = array();
		$request_id = $this->create_request($this->request->uri . ' ' . strtoupper($this->request->method));
		$response_message['request_id'] = $request_id;
		$is_authenticated = $this->request->hmac_authenticated; //authenticate request
		$is_authorized = $this->request->admin_api_authorized; //authorize request
		
		//check parameters for required fields, set defaults for non-required fields that aren't provided
		//TO-DO: username / id should be automatically determined somehow (or at least restricted more) -- id is org id and should be pulled from a certificate ideally
		if(!$this->post('group_name')) { $error = true; array_push($fields, 'group_name'); } else { $group_name = $this->post('group_name'); }
		if(!$this->post('display_name')) { $error = true; array_push($fields, 'display_name'); } else { $display_name = $this->post('display_name'); }
		if(!$this->post('description')) { $error = true; array_push($fields, 'description'); } else { $description = $this->post('description'); }
		
		
		//if there is an error with the passed in fields create an error message
		if ($error){
			if($is_authenticated) { 
				if($is_authorized) {
					//check authorization here as well
					$response_message['message'] = $this->generate_required_fields_message($fields);
					$response_message['fields'] = $fields;
					$this->requestmodel->add_response($request_id, 422, json_encode($response_message));
					$this->response($response_message, 422);
				}				
			}
		}
		
		//if authentication was successful, check if the app is authorized to use this function
		if($is_authenticated) {
			if($is_authorized) {
				//if authorized perform user creation
				$this->load->model('usersmodel');
				$this->load->model('groupsmodel');
				$this->load->model('applicationmodel');
				$app_id = $this->applicationmodel->get_application_id_from_public($this->request->public_key);
				if($this->usersmodel->username_exists($group_name) === FALSE) {
					if($this->groupsmodel->create_group($group_name,$display_name,$description)) {
						$response_message['message'] = 'Group successfully created.';
						$this->requestmodel->add_response($request_id, 200, json_encode($response_message));
						$this->response($response_message, 200);
					}
					else {
						$response_message['message'] = 'Failed to create group.';
						$this->requestmodel->add_response($request_id, 500, json_encode($response_message));
						$this->response($response_message, 500);
					}
				
				
				}
				else { 
					$response_message['message'] = 'Bad Request. Name already in use.';
					$this->requestmodel->add_response($request_id, 400, json_encode($response_message));
					$this->response($response_message, 400);
				}
			}
			else {
				$response_message['message'] = 'Access Denied. Use Not Authorized.';
				$this->requestmodel->add_response($request_id, 403, json_encode($response_message));
				$this->response($response_message, 403);
			}
		}
		else { //deny access if authentication fails
			$response_message['message'] = 'Access Denied. Authentication Failed.';
			$this->requestmodel->add_response($request_id, 401, json_encode($response_message));
			$this->response($response_message, 401);
		}
	}
	/* This function retrieves information about a request
	 */
	public function requeststatus_get(){
		$request_id = $this->create_request($this->request->uri . ' ' . strtoupper($this->request->method));
		$response_message['request_id'] = $request_id;
		
		$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
		$is_authorized = $this->request->admin_api_authorized; //authorize request
		
		if(!$is_authenticated) {
			$response_message['message'] = 'Access Denied. Authentication Failed.';
			$this->requestmodel->add_response($request_id, 401, json_encode($response_message));
			$this->response($response_message, 401);
		}
		if(!$is_authorized) {
			$response_message['message'] = 'Access Denied. Use Not Authorized.';
			$this->requestmodel->add_response($request_id, 403, json_encode($response_message));
			$this->response($response_message, 403);
		}
		
		if(!$this->get('requestid')) {
			$response_message['message'] = 'Must provide a request id.';
			$this->requestmodel->add_response($request_id, 422, json_encode($response_message));
			$this->response($response_message, 422);
		}
		
		$query = $this->requestmodel->get_request_by_id($this->get('requestid'));
		if ($query->num_rows == 0){
			$response_message['message'] = 'No request found with id '.$this->get('requestid').'.';
			$this->requestmodel->add_response($request_id, 422, json_encode($response_message));
			$this->response($response_message, 422);
		}
		$query_array = $query->row_array();
		
		$app_id = null;
		$this->get_app_id_from_header($app_id);
		
		if ($app_id !== $query_array['application_id'])
		{
			$response_message['message'] = 'Access Denied. You do not have access to this request status.';
			$this->requestmodel->add_response($request_id, 422, json_encode($response_message));
			$this->response($response_message, 422);
		}
		
		$response_message['request_row'] = $query_array;
		$this->requestmodel->add_response($request_id, 422, json_encode($response_message));
		$this->response($response_message, 200);
	}
}